import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

/**
 * @author (Ihr Name) 
 * @version (eine Versionsnummer oder ein Datum)
 */
public class Benutzerschnittstelle extends JFrame
{
    private boolean initialisiert;
    private Steuerung steuerung;
    private Sudoku sudoku;

    private HashMap <JButton, Feld> hashMapButtonFeld;
    private HashMap <JButton, Integer> hashMapButtonBenutzereingabe;

    private static final Color FELD_VERAENDERBAR = Color.green;
    private static final Color FELD_NICHT_VERAENDERBAR = Color.black;
    private static Color FELD_STANDART_HINTERGRUND = Color. white;
    private static final Color FELD_AKTUELLES_FELD = Color.yellow;
    
    private JButton beenden, pruefen, formation1, formation2, formation3;

    private JButton [] [] feld1;
    private HashSet<JButton> benutzereingabe;

    private JButton aktuellesFeld;

    private JLabel labelgewonnen;

    private JMenuBar menuBar;

    public Benutzerschnittstelle(Steuerung pSteuerung, Sudoku pSudoku)
    {
        this.steuerung = pSteuerung;
        this.sudoku = pSudoku;
        initialisiert = false;
        erstelleBildschirm(); 

    }

    private void erstelleBildschirm()
    {
        this.setName("Game of Live");
        this.setSize(900, 700);
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        this.setLayout(null);

        //Buttons
        beenden = new JButton("Beenden");
        beenden.setBounds(20, 50, 120, 20);
        add(beenden);
        beenden.addActionListener(listenerBeenden);

        pruefen = new JButton("Pruefen");
        pruefen.setBounds(160, 50, 120, 20);
        add(pruefen);
        pruefen.addActionListener(listenerButtonsPruefen);

        formation1 = new JButton("Sudoku1");
        formation1.setBounds(20, 90, 120, 20);
        add(formation1);
        formation1.addActionListener(listenerButtonsFormation1);

        formation2 = new JButton("Sudoku2");
        formation2.setBounds(20, 130, 120, 20);
        add(formation2);
        formation2.addActionListener(listenerButtonsFormation2);

        formation3 = new JButton("Sudoku3");
        formation3.setBounds(20, 170, 120, 20);
        add(formation3);
        formation3.addActionListener(listenerButtonsFormation3);

        labelgewonnen = new JLabel("");
        labelgewonnen.setBounds(300, 20, 120, 20);
        add(labelgewonnen);

        erstelleMenue();
        
        eingabeFeldInitialisieren();
        
        this.setVisible(true);
    }

    private void erstelleMenue()
    {
        menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        
        JMenu menuHelligkeit = new JMenu("Helligkeit");
        menuBar.add(menuHelligkeit);

        JMenuItem menuItemHeller = new JMenuItem("Heller");
        menuHelligkeit.add(menuItemHeller);
        menuItemHeller.addActionListener(listenerMenuItemHeller);

        JMenuItem menuItemDunkler = new JMenuItem("Dunkler");
        menuHelligkeit.add(menuItemDunkler);
        menuItemDunkler.addActionListener(listenerMenuItemDunkler);

        JMenu menu1 = new JMenu("Hilfe");
        menuBar.add(menu1);

        JMenuItem menuItemEintrag1 = new JMenuItem("Anleitung");
        menu1.add(menuItemEintrag1);
        menuItemEintrag1.addActionListener(listenerMenuItemEintrag1);

        JMenu menuVersion = new JMenu("Version");
        menuBar.add(menuVersion);

        JMenuItem menuItemVersion = new JMenuItem("Version");
        menuVersion.add(menuItemVersion);
        menuItemVersion.addActionListener(listenerMenuItemVersion);

        

    }

    private void felderAktualisieren()
    {
        if (initialisiert = true)
        {

        
            int maximalY = sudoku.gibSeitenLaenge();
            int maximalX = sudoku.gibSeitenLaenge();

            int positionY = 0;
            int positionX = 0;  

            while (positionY < maximalY)
            {
                positionX = 0;
                while (positionX < maximalX)
                {
                    JButton tmp = null;
                    tmp = feld1 [positionY] [positionX];
                    Feld felder = hashMapButtonFeld.get(tmp);

                    if (felder.getZahl() == 0)
                    {

                        tmp.setText("");
                    }
                    else if (felder.getZahl() >= 1 && felder.getZahl() <= 9)
                    {
                        tmp.setText("" + felder.getZahl());
                    }
                    else
                    {
                        System.out.println("Fehler buttonsRichtigeZahlenGeben(), else");
                    }
                    tmp.setBackground (FELD_STANDART_HINTERGRUND);

                    if (aktuellesFeld != null)
                    {
                        aktuellesFeld.setBackground (FELD_AKTUELLES_FELD);
                    }

                    positionX ++;
                }
                positionY ++;
            }

            if (steuerung.spielIstGewonnen() ==  true)
            {
                labelgewonnen.setText("Du Hast Gewonnen");
            }
        }

    }

    private void erzeugeDasSpielfeld()
    {
        feld1 = null;
        int maximalY = sudoku.gibSeitenLaenge();
        int maximalX = sudoku.gibSeitenLaenge();
        feld1 = new JButton [maximalY]  [maximalX];
        int positionY = 0;
        int positionX = 0;
        hashMapButtonFeld = null;
        hashMapButtonFeld = new HashMap<JButton, Feld> ();
        int sudokuBlock3 = 10;

        while (positionY < maximalY)
        {
            positionX = 0;
            int sudokuBlock3RelativIntY = positionY / 3;
            while (positionX < maximalX)
            {
                JButton tmp = new JButton ("x=" + positionX+1 + "   y=" + positionY+1);
                feld1 [positionY] [positionX] =  tmp;

                int sudokuBlock3RelativIntX = positionX / 3;

                tmp.setBounds(250 + (sudokuBlock3 * sudokuBlock3RelativIntX) + ((positionX + 1) * 52), 20 + (sudokuBlock3 * sudokuBlock3RelativIntY) + ((positionY + 1) * 52), 50, 50);

                hashMapButtonFeld.put(tmp, sudoku.gibFeld(positionX, positionY));
                if (sudoku.veraenderbar(positionX, positionY) == true)
                {
                    tmp.setForeground(FELD_VERAENDERBAR);
                }
                else if (sudoku.veraenderbar(positionX, positionY) == false)
                {
                    tmp.setForeground(FELD_NICHT_VERAENDERBAR);
                }

                add(tmp);
                tmp.addActionListener(listenerButtonsSpielfeld);

                positionX ++;

            }
            positionY ++;

        }
    }

    public void eingabeFeldInitialisieren()
    {
        benutzereingabe = new HashSet<JButton> ();
        hashMapButtonBenutzereingabe = new HashMap <JButton, Integer> ();

        for (int i = 0; i < 5; i++)
        {
            int x = 60;
            int y = 60;
            JButton tmp = new JButton("" + i);
            benutzereingabe.add(tmp);

            tmp.setBounds(20 + x, 300 + y * i, 50, 50);
            add(tmp);
            tmp.addActionListener(listenerButtonsBenutzereingabe);
            hashMapButtonBenutzereingabe.put(tmp, new Integer(i));  
        }

        for (int i = 5; i < 10; i++)
        {
            int x = 60;
            int y = 60;
            JButton tmp = new JButton("" + i);
            benutzereingabe.add(tmp);

            tmp.setBounds(20 + x + 60, 300 + y * (i - 5), 50, 50);
            add(tmp);
            tmp.addActionListener(listenerButtonsBenutzereingabe);
            hashMapButtonBenutzereingabe.put(tmp, new Integer(i));  
        }
    }

    public void setzeSudoku(Sudoku pSudoku)
    {
        this.sudoku = pSudoku;
    }

    private final ActionListener listenerBeenden = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){

                System.exit(0);
            }
        };

    private final ActionListener listenerButtonsFormation1 = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                if (initialisiert == false)
                {
                    steuerung.formation1();
                    erzeugeDasSpielfeld();
                    felderAktualisieren();
                    initialisiert = true;
                }
            }
        };

    private final ActionListener listenerButtonsFormation2 = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                if (initialisiert == false)
                {
                    steuerung.formation2();
                    erzeugeDasSpielfeld();
                    felderAktualisieren();
                    initialisiert = true;
                }
            }
        };

    private final ActionListener listenerButtonsFormation3 = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                if (initialisiert == false)
                {
                    steuerung.formation3();
                    erzeugeDasSpielfeld();
                    felderAktualisieren();
                    initialisiert = true;
                }
            }
        };

    private final ActionListener listenerButtonsPruefen = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){

                if (sudoku.besitztFeld() == true)
                {

                    boolean tmp = steuerung.testeObSudokuKorrektIst();
                    if (tmp)
                    {
                        pruefen.setBackground (Color.green);
                    }
                    else
                    {
                        pruefen.setBackground (Color.red);
                    }
                }
            }
        };

    private final ActionListener listenerButtonsSpielfeld = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                if (sudoku.besitztFeld() == true)
                {
                    aktuellesFeld = (JButton) e.getSource();

                    felderAktualisieren();

                }
            }
        };

    private final ActionListener listenerButtonsBenutzereingabe = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                if (sudoku.besitztFeld() == true)
                {
                    JButton tmp = (JButton) e.getSource();
                    int wert = hashMapButtonBenutzereingabe.get(tmp).intValue();
                    hashMapButtonFeld.get(aktuellesFeld).setzeZahl(wert);
                    felderAktualisieren();
                }
            }
        };

    private final ActionListener listenerMenuItemEintrag1 = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){

                JOptionPane.showMessageDialog(null, 
                    "Spielanleitung: Waehl dir links ein Sudoku.\n Dann kannst du ein Feld mit der Maus auswaehlen und eine Zahl eingeben.\n Mit pruefen kannst du sehen, ob du richtig bist. gruen = richtig. rot = falsch",
                    "", 
                    JOptionPane.INFORMATION_MESSAGE);

            }
        };

    private final ActionListener listenerMenuItemVersion = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){

                JOptionPane.showMessageDialog(null, 
                    "Sudoku\n" + steuerung.gibVersion(),
                    "Info zu Sudoku", 
                    JOptionPane.INFORMATION_MESSAGE);

            }
        };

    private final ActionListener listenerMenuItemHeller = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                FELD_STANDART_HINTERGRUND = Color.white;
                if (initialisiert == true)
                {
                    felderAktualisieren();
                }
            }
        };

    private final ActionListener listenerMenuItemDunkler = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                FELD_STANDART_HINTERGRUND = Color.lightGray;
                if (initialisiert == true)
                {
                    felderAktualisieren();
                }
            }
        };

}